import { Router } from 'express';
import { marketPricesController } from './controller';
import { authenticateUser, requireAdmin } from '@/middlewares/auth';

const router = Router();

// Attach user to req for downstream use
async function attachUser(req: any, res: any, next: any) {
  if (req.user) req.user = req.user;
  next();
}

// Attach admin to req for downstream use (simulate admin extraction)
async function attachAdmin(req: any, res: any, next: any) {
  req.admin = req.user; // Assume admin is authenticated user for now
  next();
}

// Submit market price
router.post('/', authenticateUser, attachUser, marketPricesController.submit);
// List market prices
router.get('/', authenticateUser, attachUser, marketPricesController.list);
// Get price suggestions for vendor
router.get('/suggestions', authenticateUser, attachUser, marketPricesController.suggestions);
// Admin: approve/reject pricing agent
router.patch('/admin/users/:id/pricing-access', authenticateUser, requireAdmin, attachAdmin, marketPricesController.updatePricingAccess);

export default router; 